# !/usr/bin/env python3
# -*- coding: utf-8 -*-

#*******************************************************************************
# File : get_all_data.py
# Package : AMFTools example
# Description : This module provide an example of how to get all the data from an AMF product
# Author : Paul Giroux AMF (paul.giroux@amf.ch)
# Date Created : november 07, 2023
# Date Modified : november 07, 2023
# Version : 0.1.4
# Python Version : 3.11.4
# Dependencies : pyserial, ftd2xx
# License : all Right reserved : Proprietary license (Advanced Microfluidics S.A.)
#*******************************************************************************

import amfTools # import the module

list_amf = amfTools.util.getProductList() # get the list of AMF products connected to the computer
print("\n******* List of AMF products connected to the computer *******")
for amf in list_amf:
    print(amf)
print("**************************************************************\n")

# Connect to the first AMF product of the list
amf = amfTools.AMF(list_amf[0])

# Get the data from the AMF product
data = amf.getDeviceInformation()
print("\n***************** Data from the AMF product ******************")
for i in data:
    print(i, " : ", data[i]) # print the data from the AMF product
print("**************************************************************\n")




