# !/usr/bin/env python3
# -*- coding: utf-8 -*-

#*******************************************************************************
# File : get_all_data.py
# Package : AMFTools example
# Description : This module provide an example of how to pump with an AMF SPM product
# Author : Paul Giroux AMF (paul.giroux@amf.ch)
# Date Created : november 07, 2023
# Date Modified : november 07, 2023
# Version : 0.1.4
# Python Version : 3.11.4
# Dependencies : pyserial, ftd2xx
# License : all Right reserved : Proprietary license (Advanced Microfluidics S.A.)
#*******************************************************************************

import amfTools # import the module

list_amf = amfTools.util.getProductList() # get the list of AMF products connected to the computer
print("\n******* List of AMF products connected to the computer *******")
for amf in list_amf:
    print(amf)
print("**************************************************************\n")

# Connect to the first AMF product that is an SPM of the list
product : amfTools.Device = None
for product in list_amf:
    if product.deviceType == "SPM":
        amf = amfTools.AMF(product)
        break
if product is None:
    raise Exception("No SPM product found")

# check if the product is homed (if not, home it)
if not amf.getHomeStatus():
    amf.home() # home the product

#set the pump parameters
amf.setAccelerationRate(1557) # set the aceleration rate to 1557 pulse/s^2
amf.setDecelerationRate(59590) # set the deceleration rate to 59590 pulse/s^2
amf.setSpeed(150) # set the speed to 150 pulse/s
amf.setSyringeSize(1000) # set the syringe size to 1000 µL (1 mL)

# Pump to 1500 (half of the course)
amf.pump(1500)

# Pump dispense 500 (go to 1000 in absolute position)
amf.pumpDispense(500)

# Pump pickup 1000 (go to 2000 in absolute position)
amf.pumpPickup(1000)

# Pump dispense 500 µL (1/2 of 1ml => 1/2 of the syringe size ~ dispense 1/2 of the course = 1500)
amf.pumpDispenseVolume(500) 

# Pump pickup 750 µL
amf.pumpPickupVolume(750) 

# Pump to 0 (go to 0 in absolute position)
amf.pump(0)

print("**************************************************************")
print("********************* End of the program *********************")
print("**************************************************************\n")





